﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Device.Location;
using BingMapsRESTToolkit;

namespace PpmsDataWebService.Models
{

    public class DistanceMatrixResponse
    {
        public class Destination
        {
            public double latitude { get; set; }
            public double longitude { get; set; }
        }

        public class Origin
        {
            public double latitude { get; set; }
            public double longitude { get; set; }
        }

        public class Result
        {
            public DateTime departureTime { get; set; }
            public int destinationIndex { get; set; }
            public int originIndex { get; set; }
            public int totalWalkDuration { get; set; }
            public double travelDistance { get; set; }
            public double travelDuration { get; set; }
        }

        public class Resource
        {
            public string __type { get; set; }
            public List<Destination> destinations { get; set; }
            public string errorMessage { get; set; }
            public List<Origin> origins { get; set; }
            public List<Result> results { get; set; }
        }

        public class ResourceSet
        {
            public int estimatedTotal { get; set; }
            public List<Resource> resources { get; set; }
        }

        public class RootObject
        {
            public string authenticationResultCode { get; set; }
            public string brandLogoUri { get; set; }
            public string copyright { get; set; }
            public List<ResourceSet> resourceSets { get; set; }
            public int statusCode { get; set; }
            public string statusDescription { get; set; }
            public string traceId { get; set; }
        }
    }
}